#!/bin/bash

export CUDA_LAUNCH_BLOCKING=1
export PYTORCH_CUDA_ALLOC_CONF=expandable_segments:True
export CUDA_VISIBLE_DEVICES=1,7

# "mistralai/Mistral-Small-3.1-24B-Instruct-2503"

for MODEL in "Qwen/Qwen2.5-72B-Instruct" "meta-llama/Llama-3.3-70B-Instruct"; do
        echo "Extracting activations for model: $MODEL; dataset: alpaca..."
        uv run python -m src.alpaca \
            --model $MODEL \
            --probe_dir "data/probes/RepEng/$MODEL" \
            --output_dir "data/interim/activations/alpaca" \
            --batch_size 5 \
            --target_conversations 2000 \
            --max_tokens 500 \
            --save_batch_size 32
done

    